# cPanel Node.js Deployment Guide

## Prerequisites
- cPanel hosting account with Node.js support
- Supabase account and database
- TMDB API key

## Deployment Steps

### 1. Prepare Your Files
1. Upload all project files to your cPanel file manager
2. Place files in the public_html directory or a subdirectory

### 2. Configure Node.js Application in cPanel
1. Go to "Node.js Apps" in cPanel
2. Click "Create Application"
3. Select Node.js version (16.x or higher recommended)
4. Set application root to your project directory
5. Set startup file to "server.js"
6. Click "Create"

### 3. Install Dependencies
1. In the Node.js Apps interface, click "Run NPM Install"
2. Wait for installation to complete

### 4. Set Environment Variables
1. In Node.js Apps, go to "Environment Variables"
2. Add the following variables:
   - SUPABASE_URL: Your Supabase project URL
   - SUPABASE_ANON_KEY: Your Supabase anon key
   - TMDB_API_KEY: Your TMDB API key
   - NODE_ENV: production

### 5. Configure Database
1. Run the SQL scripts in the scripts/ folder in your Supabase dashboard:
   - create-tables.sql
   - seed-data.sql
   - create-blog-tables.sql
   - seed-blog-categories.sql
   - create-admin-user.sql

### 6. Start the Application
1. Click "Restart" in the Node.js Apps interface
2. Your application should now be running

### 7. Access Your Application
- Visit your domain/subdirectory to access the application
- The application will be available at the URL configured in cPanel

## Troubleshooting

### Common Issues:
1. **Module not found errors**: Run NPM install again
2. **Database connection errors**: Check environment variables
3. **API errors**: Verify TMDB API key is correct
4. **Port conflicts**: cPanel automatically assigns ports

### Logs:
- Check application logs in cPanel Node.js Apps interface
- Look for startup errors and fix accordingly

## File Structure:
\`\`\`
project-root/
├── server.js (main application file)
├── package.json
├── .env (create from .env.example)
├── lib/
│   └── supabase.js
├── routes/
│   ├── auth.js
│   ├── blog.js
│   └── tmdb.js
├── public/
│   ├── index.html
│   └── assets/
│       ├── app.js
│       └── styles.css
└── scripts/ (SQL files for database setup)
\`\`\`

## Security Notes:
- Never commit .env file to version control
- Use strong passwords for admin accounts
- Keep dependencies updated
- Monitor application logs regularly
