import type React from "react"
import "./globals.css"
import type { Metadata } from "next"
import { Inter } from "next/font/google"
import { ThemeProvider } from "@/components/theme-provider"
import { Toaster } from "@/components/ui/toaster"

const inter = Inter({ subsets: ["latin"] })

export const metadata: Metadata = {
  title: {
    default: "MoviesWeb - Your Ultimate Movie & TV Show Database",
    template: "%s | MoviesWeb",
  },
  description:
    "Discover movies, TV shows, cast information, and more on MoviesWeb. Your comprehensive entertainment database.",
  keywords: ["movies", "tv shows", "entertainment", "database", "MoviesWeb"],
  authors: [{ name: "MoviesWeb" }],
  creator: "MoviesWeb",
  publisher: "MoviesWeb",
  metadataBase: new URL("https://moviesweb.in"),
  openGraph: {
    type: "website",
    locale: "en_US",
    url: "https://moviesweb.in",
    siteName: "MoviesWeb",
    title: "MoviesWeb - Your Ultimate Movie & TV Show Database",
    description: "Discover movies, TV shows, cast information, and more on MoviesWeb.",
  },
  twitter: {
    card: "summary_large_image",
    title: "MoviesWeb - Your Ultimate Movie & TV Show Database",
    description: "Discover movies, TV shows, cast information, and more on MoviesWeb.",
    creator: "@moviesweb",
  },
  robots: {
    index: true,
    follow: true,
  },
    generator: 'v0.dev'
}

export default function RootLayout({
  children,
}: {
  children: React.ReactNode
}) {
  return (
    <html lang="en" suppressHydrationWarning>
      <body className={inter.className}>
        <ThemeProvider attribute="class" defaultTheme="dark" enableSystem disableTransitionOnChange>
          {children}
          <Toaster />
        </ThemeProvider>
      </body>
    </html>
  )
}
