"use client"

import type React from "react"

import { useState } from "react"
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card"
import { Button } from "@/components/ui/button"
import { Badge } from "@/components/ui/badge"
import { Alert, AlertDescription } from "@/components/ui/alert"
import { Shield, Eye, EyeOff, AlertTriangle } from "lucide-react"

interface AdultContentWarningProps {
  isAdult: boolean
  title: string
  children: React.ReactNode
  type?: "movie" | "tv" | "episode"
}

export function AdultContentWarning({ isAdult, title, children, type = "movie" }: AdultContentWarningProps) {
  const [showContent, setShowContent] = useState(false)

  if (!isAdult) {
    return <>{children}</>
  }

  if (!showContent) {
    return (
      <Card className="border-orange-200 bg-orange-50 dark:border-orange-800 dark:bg-orange-950">
        <CardHeader className="text-center">
          <div className="mx-auto mb-4 flex h-16 w-16 items-center justify-center rounded-full bg-orange-100 dark:bg-orange-900">
            <Shield className="h-8 w-8 text-orange-600" />
          </div>
          <CardTitle className="text-orange-800 dark:text-orange-200">Adult Content Warning</CardTitle>
          <CardDescription className="text-orange-700 dark:text-orange-300">
            This {type} contains mature content that may not be suitable for all audiences.
          </CardDescription>
        </CardHeader>
        <CardContent className="space-y-4 text-center">
          <div className="space-y-2">
            <Badge
              variant="outline"
              className="border-orange-300 text-orange-700 dark:border-orange-700 dark:text-orange-300"
            >
              <AlertTriangle className="h-3 w-3 mr-1" />
              18+ Content
            </Badge>
            <h3 className="font-semibold text-orange-800 dark:text-orange-200">{title}</h3>
          </div>

          <Alert className="border-orange-200 bg-orange-100 dark:border-orange-800 dark:bg-orange-900">
            <AlertTriangle className="h-4 w-4 text-orange-600" />
            <AlertDescription className="text-orange-700 dark:text-orange-300">
              This content is intended for mature audiences only. By proceeding, you confirm that you are 18 years or
              older.
            </AlertDescription>
          </Alert>

          <div className="flex flex-col sm:flex-row gap-3 justify-center">
            <Button onClick={() => setShowContent(true)} className="bg-orange-600 hover:bg-orange-700 text-white">
              <Eye className="h-4 w-4 mr-2" />
              I'm 18+ - Show Content
            </Button>
            <Button
              variant="outline"
              onClick={() => window.history.back()}
              className="border-orange-300 text-orange-700 hover:bg-orange-100 dark:border-orange-700 dark:text-orange-300 dark:hover:bg-orange-900"
            >
              <EyeOff className="h-4 w-4 mr-2" />
              Go Back
            </Button>
          </div>
        </CardContent>
      </Card>
    )
  }

  return (
    <div className="space-y-4">
      <Alert className="border-orange-200 bg-orange-50 dark:border-orange-800 dark:bg-orange-950">
        <Shield className="h-4 w-4 text-orange-600" />
        <AlertDescription className="text-orange-700 dark:text-orange-300">
          <strong>Adult Content:</strong> This {type} contains mature themes and is intended for audiences 18+.
        </AlertDescription>
      </Alert>
      {children}
    </div>
  )
}
