"use client"

import { useContentFilter } from "@/hooks/use-content-filter"
import { Alert, AlertDescription } from "@/components/ui/alert"
import { Button } from "@/components/ui/button"
import { Shield, LogIn } from "lucide-react"
import Link from "next/link"

export function ContentFilterNotice() {
  const { user, canViewAdultContent } = useContentFilter()

  if (user && canViewAdultContent) {
    return null
  }

  return (
    <Alert className="border-blue-200 bg-blue-50 dark:border-blue-800 dark:bg-blue-950 mb-6">
      <Shield className="h-4 w-4 text-blue-600" />
      <AlertDescription className="text-blue-700 dark:text-blue-300">
        <div className="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-3">
          <div>
            <strong>Content Filter Active:</strong> Adult content is hidden. {!user && "Sign in to access all content."}
          </div>
          {!user && (
            <Button size="sm" asChild className="bg-blue-600 hover:bg-blue-700 text-white">
              <Link href="/login">
                <LogIn className="h-4 w-4 mr-2" />
                Sign In
              </Link>
            </Button>
          )}
        </div>
      </AlertDescription>
    </Alert>
  )
}
