"use client"

import { useState, useEffect } from "react"
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card"
import { Badge } from "@/components/ui/badge"
import { Bookmark, Film } from "lucide-react"

interface UserWatchlistProps {
  userId: string
}

export function UserWatchlist({ userId }: UserWatchlistProps) {
  const [watchlist, setWatchlist] = useState([])
  const [loading, setLoading] = useState(true)

  useEffect(() => {
    // Simulate loading watchlist
    setTimeout(() => {
      setWatchlist([])
      setLoading(false)
    }, 1000)
  }, [userId])

  if (loading) {
    return (
      <Card>
        <CardContent className="flex items-center justify-center py-12">
          <div className="text-center">
            <div className="animate-spin rounded-full h-8 w-8 border-b-2 border-primary mx-auto mb-4"></div>
            <p className="text-muted-foreground">Loading your watchlist...</p>
          </div>
        </CardContent>
      </Card>
    )
  }

  return (
    <div className="space-y-6">
      <Card>
        <CardHeader>
          <CardTitle className="flex items-center gap-2">
            <Bookmark className="h-5 w-5 text-blue-500" />
            Watch Later
          </CardTitle>
          <CardDescription>Movies you want to watch later</CardDescription>
        </CardHeader>
        <CardContent>
          {watchlist.length === 0 ? (
            <div className="text-center py-12">
              <Film className="h-12 w-12 text-muted-foreground mx-auto mb-4" />
              <h3 className="text-lg font-semibold mb-2">Your watchlist is empty</h3>
              <p className="text-muted-foreground mb-4">
                Add movies to your watchlist to keep track of what you want to watch!
              </p>
              <Badge variant="outline">Click the bookmark icon on any movie to add it here</Badge>
            </div>
          ) : (
            <div className="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-4">
              {/* Watchlist movies would be rendered here */}
            </div>
          )}
        </CardContent>
      </Card>
    </div>
  )
}
