"use client"

import { useState, useEffect } from "react"
import { createClient } from "@/lib/supabase"

export function useContentFilter() {
  const [user, setUser] = useState<any>(null)
  const [loading, setLoading] = useState(true)
  const [showAdultContent, setShowAdultContent] = useState(false)
  const supabase = createClient()

  useEffect(() => {
    const getUser = async () => {
      try {
        const {
          data: { session },
        } = await supabase.auth.getSession()
        setUser(session?.user || null)

        // Only show adult content if user is logged in
        setShowAdultContent(!!session?.user)
      } catch (error) {
        console.log("Auth error:", error)
        setUser(null)
        setShowAdultContent(false)
      } finally {
        setLoading(false)
      }
    }

    getUser()

    const {
      data: { subscription },
    } = supabase.auth.onAuthStateChange((event, session) => {
      setUser(session?.user || null)

      // Automatically hide adult content on logout
      if (event === "SIGNED_OUT") {
        setShowAdultContent(false)
      } else if (event === "SIGNED_IN" && session?.user) {
        setShowAdultContent(true)
      }
    })

    return () => subscription.unsubscribe()
  }, [supabase.auth])

  const filterAdultContent = <T extends { adult?: boolean }>(items: T[]): T[] => {
    if (showAdultContent) {
      return items
    }
    return items.filter((item) => !item.adult)
  }

  const isAdultContent = (item: { adult?: boolean }): boolean => {
    return !!item.adult
  }

  const canViewAdultContent = (): boolean => {
    return showAdultContent && !!user
  }

  return {
    user,
    loading,
    showAdultContent,
    canViewAdultContent,
    filterAdultContent,
    isAdultContent,
  }
}
