import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card"
import { Badge } from "@/components/ui/badge"
import { Shield, User, Database } from "lucide-react"

export function AdminSetupNotice() {
  return (
    <div className="space-y-6">
      <Card className="border-orange-200 bg-orange-50 dark:border-orange-800 dark:bg-orange-950">
        <CardHeader>
          <div className="flex items-center space-x-2">
            <Shield className="h-5 w-5 text-orange-600" />
            <CardTitle className="text-orange-800 dark:text-orange-200">Admin Setup Required</CardTitle>
          </div>
          <CardDescription className="text-orange-700 dark:text-orange-300">
            To access the admin panel, you need to set up an admin user account.
          </CardDescription>
        </CardHeader>
        <CardContent className="space-y-4">
          <div className="space-y-3">
            <div className="flex items-start space-x-3">
              <Badge variant="outline" className="mt-0.5">
                1
              </Badge>
              <div>
                <p className="font-medium text-orange-800 dark:text-orange-200">Sign up with admin credentials</p>
                <p className="text-sm text-orange-700 dark:text-orange-300">
                  Email:{" "}
                  <code className="bg-orange-100 dark:bg-orange-900 px-1 rounded">freefire.max2050@gmail.com</code>
                </p>
                <p className="text-sm text-orange-700 dark:text-orange-300">
                  Password: <code className="bg-orange-100 dark:bg-orange-900 px-1 rounded">7456839682Ab@</code>
                </p>
              </div>
            </div>

            <div className="flex items-start space-x-3">
              <Badge variant="outline" className="mt-0.5">
                2
              </Badge>
              <div>
                <p className="font-medium text-orange-800 dark:text-orange-200">Run the admin setup script</p>
                <p className="text-sm text-orange-700 dark:text-orange-300">
                  Execute the SQL script to grant admin privileges to your account.
                </p>
              </div>
            </div>

            <div className="flex items-start space-x-3">
              <Badge variant="outline" className="mt-0.5">
                3
              </Badge>
              <div>
                <p className="font-medium text-orange-800 dark:text-orange-200">Access the admin panel</p>
                <p className="text-sm text-orange-700 dark:text-orange-300">
                  Once setup is complete, you can access all admin features.
                </p>
              </div>
            </div>
          </div>
        </CardContent>
      </Card>

      <div className="grid grid-cols-1 md:grid-cols-3 gap-4">
        <Card>
          <CardContent className="flex items-center p-4">
            <User className="h-8 w-8 text-blue-500 mr-3" />
            <div>
              <h3 className="font-semibold">User Management</h3>
              <p className="text-sm text-muted-foreground">Manage user accounts and roles</p>
            </div>
          </CardContent>
        </Card>

        <Card>
          <CardContent className="flex items-center p-4">
            <Database className="h-8 w-8 text-green-500 mr-3" />
            <div>
              <h3 className="font-semibold">Content Management</h3>
              <p className="text-sm text-muted-foreground">Add, edit, and remove movies</p>
            </div>
          </CardContent>
        </Card>

        <Card>
          <CardContent className="flex items-center p-4">
            <Shield className="h-8 w-8 text-purple-500 mr-3" />
            <div>
              <h3 className="font-semibold">TMDB Integration</h3>
              <p className="text-sm text-muted-foreground">Sync with TMDB API</p>
            </div>
          </CardContent>
        </Card>
      </div>
    </div>
  )
}
