const express = require("express")
const cors = require("cors")
const path = require("path")
require("dotenv").config()

const app = express()
const PORT = process.env.PORT || 3000

// Middleware
app.use(cors())
app.use(express.json())
app.use(express.urlencoded({ extended: true }))
app.use(express.static("public"))

// Import routes
const tmdbRoutes = require("./routes/tmdb")
const blogRoutes = require("./routes/blog")
const authRoutes = require("./routes/auth")

// Use routes
app.use("/api/tmdb", tmdbRoutes)
app.use("/api/blog", blogRoutes)
app.use("/api/auth", authRoutes)

// Serve static files
app.get("*", (req, res) => {
  res.sendFile(path.join(__dirname, "public", "index.html"))
})

// Error handling middleware
app.use((err, req, res, next) => {
  console.error(err.stack)
  res.status(500).json({ error: "Something went wrong!" })
})

app.listen(PORT, () => {
  console.log(`Server running on port ${PORT}`)
})

module.exports = app
