import { Header } from "@/components/header"
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card"
import { Badge } from "@/components/ui/badge"
import { Film, Users, Globe, Heart, Star, Zap } from "lucide-react"

export const metadata = {
  title: "About MoviesWeb",
  description: "Learn more about MoviesWeb - your ultimate movie and TV show database.",
}

export default function AboutPage() {
  return (
    <div className="min-h-screen bg-background">
      <Header />

      <div className="container mx-auto px-4 py-12">
        <div className="max-w-4xl mx-auto">
          <div className="text-center mb-12">
            <div className="flex items-center justify-center mb-6">
              <Film className="h-12 w-12 text-primary mr-4" />
              <h1 className="text-4xl font-bold">About MoviesWeb</h1>
            </div>
            <p className="text-xl text-muted-foreground max-w-2xl mx-auto">
              Your comprehensive destination for discovering, exploring, and staying updated with the world of movies
              and television.
            </p>
          </div>

          <div className="grid grid-cols-1 md:grid-cols-2 gap-8 mb-12">
            <Card>
              <CardHeader>
                <Globe className="h-8 w-8 text-primary mb-2" />
                <CardTitle>Our Mission</CardTitle>
              </CardHeader>
              <CardContent>
                <CardDescription className="text-base">
                  MoviesWeb aims to be the ultimate resource for movie and TV show enthusiasts. We provide comprehensive
                  information, detailed reviews, and personalized recommendations to help you discover your next
                  favorite watch.
                </CardDescription>
              </CardContent>
            </Card>

            <Card>
              <CardHeader>
                <Users className="h-8 w-8 text-primary mb-2" />
                <CardTitle>Community Driven</CardTitle>
              </CardHeader>
              <CardContent>
                <CardDescription className="text-base">
                  Built for movie lovers, by movie lovers. Our platform brings together a community of entertainment
                  enthusiasts who share their passion for great storytelling and cinematic experiences.
                </CardDescription>
              </CardContent>
            </Card>
          </div>

          <div className="mb-12">
            <h2 className="text-2xl font-bold mb-6 text-center">What We Offer</h2>
            <div className="grid grid-cols-1 md:grid-cols-3 gap-6">
              <Card className="text-center">
                <CardHeader>
                  <Star className="h-8 w-8 text-primary mx-auto mb-2" />
                  <CardTitle>Comprehensive Database</CardTitle>
                </CardHeader>
                <CardContent>
                  <CardDescription>
                    Access detailed information about thousands of movies and TV shows, including cast, crew, ratings,
                    and reviews.
                  </CardDescription>
                </CardContent>
              </Card>

              <Card className="text-center">
                <CardHeader>
                  <Zap className="h-8 w-8 text-primary mx-auto mb-2" />
                  <CardTitle>Real-time Updates</CardTitle>
                </CardHeader>
                <CardContent>
                  <CardDescription>
                    Stay current with the latest releases, trending content, and upcoming premieres in the entertainment
                    world.
                  </CardDescription>
                </CardContent>
              </Card>

              <Card className="text-center">
                <CardHeader>
                  <Heart className="h-8 w-8 text-primary mx-auto mb-2" />
                  <CardTitle>Personalized Experience</CardTitle>
                </CardHeader>
                <CardContent>
                  <CardDescription>
                    Create your watchlist, rate content, and get personalized recommendations based on your preferences.
                  </CardDescription>
                </CardContent>
              </Card>
            </div>
          </div>

          <Card className="mb-12">
            <CardHeader>
              <CardTitle>Our Features</CardTitle>
              <CardDescription>Everything you need to explore the world of entertainment</CardDescription>
            </CardHeader>
            <CardContent>
              <div className="grid grid-cols-2 md:grid-cols-4 gap-4">
                <Badge variant="secondary" className="p-2 justify-center">
                  Movie Database
                </Badge>
                <Badge variant="secondary" className="p-2 justify-center">
                  TV Show Catalog
                </Badge>
                <Badge variant="secondary" className="p-2 justify-center">
                  Cast Information
                </Badge>
                <Badge variant="secondary" className="p-2 justify-center">
                  Trailers & Videos
                </Badge>
                <Badge variant="secondary" className="p-2 justify-center">
                  User Reviews
                </Badge>
                <Badge variant="secondary" className="p-2 justify-center">
                  Watchlists
                </Badge>
                <Badge variant="secondary" className="p-2 justify-center">
                  Trending Content
                </Badge>
                <Badge variant="secondary" className="p-2 justify-center">
                  Search & Filter
                </Badge>
              </div>
            </CardContent>
          </Card>

          <div className="text-center">
            <h2 className="text-2xl font-bold mb-4">Join the MoviesWeb Community</h2>
            <p className="text-muted-foreground mb-6 max-w-2xl mx-auto">
              Whether you're a casual viewer or a dedicated cinephile, MoviesWeb has something for everyone. Join our
              growing community and discover your next favorite movie or TV show today.
            </p>
            <div className="flex flex-wrap justify-center gap-2">
              <Badge variant="outline">🎬 Movie Enthusiasts</Badge>
              <Badge variant="outline">📺 TV Show Fans</Badge>
              <Badge variant="outline">🎭 Cinema Lovers</Badge>
              <Badge variant="outline">🍿 Entertainment Seekers</Badge>
            </div>
          </div>
        </div>
      </div>
    </div>
  )
}
